import os
import subprocess
import tempfile

def easydb_server_start(easydb_context):
    logger = easydb_context.get_logger('transport.rsync')
    logger.debug('Hello, World!')

    easydb_context.register_callback('export_transport', {
        'transport_type': 'rsync',
        'callback': 'rsync',
    })

def rsync(easydb_context, protocol):
    logger = easydb_context.get_logger('transport.rsync')
    logger.debug('Hello again, World!')

    exp = easydb_context.get_exporter()

    transport = exp.getCurrentTransport()
    if not transport:
        raise Exception("failed to find 'rsync' transport")

    tmp_filelist = tempfile.NamedTemporaryFile(delete = False)
    try:
        for fo in exp.getFiles():
            tmp_filelist.write(fo['path'].encode('utf-8'))
            tmp_filelist.write('\n'.encode('ascii'))
        tmp_filelist.close()

        opts = transport['options']

        target = '%s@%s:%s' % (opts.get('user'), opts.get('host'), opts.get('path', ''))

        args = [
            '--verbose',
            '--files-from=%s' % tmp_filelist.name,
            exp.getFilesPath(),
            target,
        ]

        (ret, out, err) = run_rsync(args)
        if not ret:
            logger.error('failed to run rsync:\n{0}'.format(err.decode('utf-8')))
            raise Exception('failed to run rsync')

        protocol.add_warning(out.decode('utf-8'))
    except:
        raise
    finally:
        os.unlink(tmp_filelist.name)

def run_rsync(args):
    proc = subprocess.Popen(['rsync',] + args,
        close_fds = True,
        stdin = os.open("/dev/null", os.O_RDONLY),
        stdout = subprocess.PIPE,
        stderr = subprocess.PIPE)
    c = proc.communicate()
    return bool(proc.returncode == 0), c[0], c[1]


if __name__ == '__main__':
    class Exporter(object):
        def getFiles(self):
            return [
                { 'path': 'tmp/test.png' }
            ]
        def getFilesPath(self):
            return '/home/mad'
        def getExport(self):
            return {
                '_transports': [
                    {
                        'type': 'rsync',
                        'options': {
                            'user': 'mad',
                            'host': 'galaxy',
                            'public_key': 'ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEArMawX6y1e77xS8v/MKaKrMarY/0T76tDNZnPJ6xrto09yLDqDzJ8HD9II2CbebOYyHw5LZmk6wHFg2xhNfXpKKRP/+3yefeafHqTjA1SOhAD0hfRVyrg6ql9JyqXDcm9w4Ozgr0ystnvDstXTAe7GFsh6RhpyXDWF8GiqTq/nIcaR3herhBv42kYAmKEN1JhGl8NQTUOM4BTeg5IQtMFyGEwua0u/fJmY4DagH/joaAz6MWMzTqi4yaDqgcWxQ1OQxGpKqlysPAQS+JQP2DXHGLYCsViGsjJoRIiI/Aw9fIozIeWMfKCpYTxSnSd1KUtTACQNkWK9sTPTWR/ghYPnQ==',
                            'path': '/tmp'
                        },
                    }
                ]
            }
    class Logger (object):
        def debug(self, text):
            print(text)
        def error(self, text):
            print(text)
    class EasydbCtxt (object):
        def get_logger(self, name):
            return Logger()
        def get_exporter(self):
            return Exporter()
    class Protocol (object):
        def add_warning(self, text):
            print(text)

    rsync(EasydbCtxt(), None, Protocol())
